<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Public routes
Route::post('/login', [\App\Http\Controllers\Auth\AuthController::class, 'login']);
Route::post('/send-otp', [\App\Http\Controllers\Auth\AuthController::class, 'sendOtp']);
Route::post('/verify-otp', [\App\Http\Controllers\Auth\AuthController::class, 'verifyOtp']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [\App\Http\Controllers\Auth\AuthController::class, 'logout']);
    Route::post('/email/verify', [\App\Http\Controllers\Auth\AuthController::class, 'verifyEmail']);

    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Example role-protected route
    Route::middleware('role:admin')->get('/admin/dashboard', function () {
        return response()->json(['message' => 'Welcome Admin']);
    });
});

